
package GttMatch;

import gt.app.GTResult;
import gt.app.GTSubTask;
import gt.gtinterface.ResultMgrIF;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Vector;

// Referenced classes of package GttMatch:
//            AlignSimple, Blosum50, Traceback2, Result, 
//            Data, MyResult, Align, Substitution, 
//            Traceback, Output

class MatchTask extends AlignSimple
{

    public MatchTask(String s, InetAddress inetaddress, String s1, int i, short word0, Vector vector, Vector             Output output)
    {
        super(s, inetaddress, s1, i, word0);
        out = output;
        group1 = vector;
        group2 = vector1;
    }

    private Result match(Data data, Data data1)
    {
        sub = new Blosum50();
        String s = strip(data.getSeq());
        String s1 = strip(data1.getSeq());
        short word0 = (short)s.length();
        short word1 = (short)s1.length();
        F = new short[word0 + 1][word1 + 1];
        B = new Traceback2[word0 + 1][word1 + 1];
        short word2 = word0;
        int i = word1;
        short word3 = -16384;
        for(short word4 = 1; word4 <= word0; word4++)
        {
            for(short word5 = 1; word5 <= word1; word5++)
            {
                short word6 = sub.score[s.charAt(word4 - 1)][s1.charAt(word5 - 1)];
                short word7 = Align.max((short)0, (short)(F[word4 - 1][word5 - 1] + word6), (short)(F[word4 - 1]                F[word4][word5] = word7;
                if(word7 == 0)
                    B[word4][word5] = null;
                else
                if(word7 == F[word4 - 1][word5 - 1] + word6)
                    B[word4][word5] = new Traceback2((short)(word4 - 1), (short)(word5 - 1));
                else
                if(word7 == F[word4 - 1][word5] - d)
                    B[word4][word5] = new Traceback2((short)(word4 - 1), word5);
                else
                if(word7 == F[word4][word5 - 1] - d)
                    B[word4][word5] = new Traceback2(word4, (short)(word5 - 1));
                else
                    throw new Error("SW 1");
                if(word7 > word3)
                {
                    word3 = word7;
                    word2 = word4;
                    i = word5;
                }
            }

        }

        B0 = new Traceback2(word2, i);
        String as[] = getMatch(s, s1);
        short word8 = getScore();
        F = null;
        B = null;
        System.gc();
        System.runFinalization();
        return new Result(word8, new Data(as[0], data.getDesc()), new Data(as[1], data1.getDesc()));
    }

    public void run()
    {
        System.out.println("Running subtask: " + m_Subpid);
        Vector vector = new Vector();
        for(int i = 0; i < group1.size(); i++)
        {
            Data data = (Data)group1.elementAt(i);
            for(int j = 0; j < group2.size(); j++)
            {
                if(!m_bKeepRunning)
                    break;
                Data data1 = (Data)group2.elementAt(j);
                Result result = match(data, data1);
                vector.addElement(result);
            }

        }

        try
        {
            m_GTResult.setResult(new MyResult(vector, m_Subpid));
            getResultMgrIF().putResult(m_Pid, m_Subpid, m_nType, m_GTResult);
        }
        catch(Exception exception)
        {
            System.out.println("Failed in putting result back to remote parent ResultMgr RMI Server for subtask: " +         }
    }

    public String[] getMatch(String s, String s1)
    {
        StringBuffer stringbuffer = new StringBuffer();
        StringBuffer stringbuffer1 = new StringBuffer();
        Traceback traceback = B0;
        short word0 = traceback.i;
        for(short word1 = traceback.j; (traceback = next(traceback)) != null; word1 = traceback.j)
        {
            if(word0 == traceback.i)
                stringbuffer.append('-');
            else
                stringbuffer.append(s.charAt(word0 - 1));
            if(word1 == traceback.j)
                stringbuffer1.append('-');
            else
                stringbuffer1.append(s1.charAt(word1 - 1));
            word0 = traceback.i;
        }

        String as[] = {
            stringbuffer.reverse().toString(), stringbuffer1.reverse().toString()
        };
        return as;
    }

    Vector group1;
    Vector group2;
    Output out;
}



